/*
 * TagElements.groovy
 * 
 * This script tags elements that are listed in an external file.
 * The file is formatted as follows:
 *
 * Tag Name 1
 *     Element Name
 *     Element Name
 *     ...
 * Tag Name 2
 *     Element Name
 *     Element Name
 *     ...
 * ...
 * 
 * Created on October 3, 2009
 *
 * Copyright (c) 2003-2009 Lattix, Inc.  All rights reserved.
 * 
 */

import java.io.*;
import com.lattix.api.*;
import com.lattix.core.depends.*;
import com.lattix.core.partition.*;

@RequiresVersion("7.0")
@Keyword(id="domain", value="Java,.NET,C/C++,LDI")
@ScriptDescription("Custom Tagging")

@Action("TagElementsListedInFile")

def action(@Arg("Input File") File file) {

	// Open File
	BufferedReader reader = null;
	try {
		reader = new BufferedReader(new FileReader(file));
	} catch (Exception e) {
		println "ERROR: Unable to open file";
		return;
	}
	String filename = file.getName();
	println("Reading: $filename");

	ProjectModel model = getModel();
	PartitionSet set = model.newPartitionSet();
	String tagname = null;
	String line, elementname;

	// Iterate through the file processing tags and elements
	while (true) {
		line = reader.readLine();
		if ((line!=null) && (line.length()==0))
			continue;

		// Deal with Tag
		if ((line==null) || ((line[0]!=' ') && (line[0]!='\t'))) {

			if (tagname != null)  {
				def tag = model.getTag(tagname);
				if (!tag) {
					tag = model.newTag(tagname, java.awt.Color.BLUE);
				}
				println("Setting the Tag: $tagname");
				model.setTagPartitions(tag, set);
				// set.each { def name = it.getName(); print("tagged atom: $name\n"); }
			}

			// End of File has been reached
			if (line == null)
				break;

			line = line.trim();
			tagname = line;
			set = model.newPartitionSet();
			continue;
		}

		// Deal with Element
		elementname = line.trim();
		Atom element = model.getAtom(elementname);
		if (element) {
			def part = model.getPartition(element);
			if (part) {
				// println("partition added to set: " + part.getName());
				set.add(part);
			}
		}
		else {
			print("No such element: $elementname\n");
		}
	}

	// Done   
	reader.close();
}

@Localize()
def en = [
	"TagElementsListedInFile" : "Tag Elements listed in File",
];

@Localize("ja")
def ja = [
	"TagElementsListedInFile" : "\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u3067\u6307\u5b9a\u3055\u308c\u305f\u69cb\u6210\u3067\u30bf\u30b0\u3092\u4ed8\u4e0e",
];
